/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.ui.impl;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.ConnectType;
import com.cisco.pt.ipc.enums.DeviceType;
import com.cisco.pt.ipc.impl.IPCObjectImpl;
import com.cisco.pt.ipc.ui.ComponentItem;
import com.cisco.pt.ipc.ui.LogicalWorkspace;
import com.cisco.pt.ptmp.PacketTracerSession;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalWorkspaceImpl
extends IPCObjectImpl
implements LogicalWorkspace {
    public LogicalWorkspaceImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public int getState() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getState");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.getState");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public List<UUID> getCanvasItemIds() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCanvasItemIds");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        List rawList = (List)returnMessage.getObjectValue();
        ArrayList<UUID> answer = new ArrayList<UUID>();
        for (Object o : rawList) {
            answer.add((UUID)o);
        }
        return answer;
    }

    @Override
    public int getCanvasItemX(UUID item_id) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCanvasItemX");
        newCall.addUUIDParameter(item_id);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.getCanvasItemX");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public int getCanvasItemY(UUID item_id) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getCanvasItemY");
        newCall.addUUIDParameter(item_id);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.getCanvasItemY");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public void setCanvasItemX(UUID item_id, int x) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setCanvasItemX");
        newCall.addUUIDParameter(item_id);
        newCall.addIntParameter(x);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void setCanvasItemY(UUID item_id, int y) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setCanvasItemY");
        newCall.addUUIDParameter(item_id);
        newCall.addIntParameter(y);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public void moveCanvasItemBy(UUID item_id, int dx, int dy) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveCanvasItemBy");
        newCall.addUUIDParameter(item_id);
        newCall.addIntParameter(dx);
        newCall.addIntParameter(dy);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getComponentItemsCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getComponentItemsCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.getComponentItemsCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public ComponentItem getComponentItem(String deviceName) {
        return this.getFactory().getComponentItem(this, deviceName);
    }

    @Override
    public String addDevice(DeviceType type, String model) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addDevice");
        newCall.addIntParameter(type.getIntValue());
        newCall.addStringParameter(model);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public boolean removeDevice(String deviceName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeDevice");
        newCall.addQStringParameter(deviceName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.removeDevice");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public String addRemoteNetwork() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addRemoteNetwork");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    @Override
    public boolean removeRemoteNetwork(String name) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeRemoteNetwork");
        newCall.addQStringParameter(name);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.removeRemoteNetwork");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean moveRemoteNetwork(String name, int x, int y) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("moveRemoteNetwork");
        newCall.addQStringParameter(name);
        newCall.addIntParameter(x);
        newCall.addIntParameter(y);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.moveRemoteNetwork");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean createLink(String deviceName1, String portName1, String deviceName2, String portName2, ConnectType connType) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("createLink");
        newCall.addQStringParameter(deviceName1);
        newCall.addStringParameter(portName1);
        newCall.addQStringParameter(deviceName2);
        newCall.addStringParameter(portName2);
        newCall.addIntParameter(connType.getIntValue());
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.createLink");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean deleteLink(String deviceName1, String portName1) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("deleteLink");
        newCall.addQStringParameter(deviceName1);
        newCall.addStringParameter(portName1);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.deleteLink");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public boolean clearLayer(double layerNumber) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("clearLayer");
        newCall.addDoubleParameter(layerNumber);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.clearLayer");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public UUID drawLine(int sx, int sy, int ex, int ey, double layer, int w, int r, int g, int b) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("drawLine");
        newCall.addIntParameter(sx);
        newCall.addIntParameter(sy);
        newCall.addIntParameter(ex);
        newCall.addIntParameter(ey);
        newCall.addDoubleParameter(layer);
        newCall.addIntParameter(w);
        newCall.addIntParameter(r);
        newCall.addIntParameter(g);
        newCall.addIntParameter(b);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (UUID)returnMessage.getObjectValue();
    }

    @Override
    public UUID drawCircle(int cx, int cy, double layer, int radius, int r, int g, int b) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("drawCircle");
        newCall.addIntParameter(cx);
        newCall.addIntParameter(cy);
        newCall.addDoubleParameter(layer);
        newCall.addIntParameter(radius);
        newCall.addIntParameter(r);
        newCall.addIntParameter(g);
        newCall.addIntParameter(b);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (UUID)returnMessage.getObjectValue();
    }

    @Override
    public UUID addNote(int x, int y, double layer, String text) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addNote");
        newCall.addIntParameter(x);
        newCall.addIntParameter(y);
        newCall.addDoubleParameter(layer);
        newCall.addQStringParameter(text);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (UUID)returnMessage.getObjectValue();
    }

    @Override
    public boolean removeCanvasItem(UUID id) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeCanvasItem");
        newCall.addUUIDParameter(id);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.removeCanvasItem");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public double getUnusedLayer() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getUnusedLayer");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.getUnusedLayer");
        }
        return returnMessage.getDoubleValue();
    }

    @Override
    public boolean isLayerUsed(double layer) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isLayerUsed");
        newCall.addDoubleParameter(layer);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.isLayerUsed");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public double getLayerInbetweenComponents(String deviceName1, String deviceName2) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getLayerInbetweenComponents");
        newCall.addQStringParameter(deviceName1);
        newCall.addQStringParameter(deviceName2);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: LogicalWorkspaceImpl.getLayerInbetweenComponents");
        }
        return returnMessage.getDoubleValue();
    }
}

